from .cifar10 import *
from .wikitext103 import *
from .openwebtext import *


name_to_data = {
    "cifar10": lambda config: cifar10(config),
    "wikitext103": lambda config: wikitext103(config),
    "owt": lambda config: OWT(config),
}


def get_dataset(config):
    name = config.name.lower()
    return name_to_data[name](config)
